-- ScreenOptionsCover icon is a bit different.
local iIndex = Var("GameCommand"):GetIndex();
local sName = Var("GameCommand"):GetName();
local pn = sName == "Player1" and PLAYER_1 or PLAYER_2;
local pName = pname(pn);

local coverAmount;
if GetUserPref("CoverPosition"..pName) == nil then
	coverAmount = 0;
	SetUserPref("CoverPosition"..pName, coverAmount);
else
	coverAmount = tonumber(GetUserPref("CoverPosition"..pName));
end;

local coverFile;
if File.Read("Themes/moonlight/Graphics/_gameplay covers/setting.cfg") then
	coverFile = tostring( File.Read("Themes/moonlight/Graphics/_gameplay covers/setting.cfg") );
else
	coverFile = "default";
end;

local t = Def.ActorFrame{};

t[#t+1] = Def.ActorFrame{
	Name="Item"..iIndex;

	LoadActor( THEME:GetPathG("_gameplay","covers/".. coverFile .."/4panel") )..{
		OnCommand=cmd(draworder,95;addy,SCREEN_BOTTOM - coverAmount);
		GainFocusCommand=cmd(accelerate,0.15;diffuse,color("1,1,1,0.9"));
		LoseFocusCommand=cmd(stoptweening;decelerate,0.15;diffuse,color("0.6,0.6,0.6,0.9"));
	};

	AutoText("blaster_shiny")..{
		Text=string.format("%i",coverAmount);
		InitCommand=cmd(y,SCREEN_CENTER_Y*0.45;draworder,97;shadowlength,1;NoStroke);
		GainFocusCommand=cmd(accelerate,0.15;diffuse,PlayerColor(pn));
		LoseFocusCommand=cmd(stoptweening;decelerate,0.15;diffuse,PlayerDarkColor(pn));
	};

	AutoText("frutiger")..{
		Text="Player ".. iIndex+1;
		InitCommand=cmd(shadowlength,1;diffuse,color("#FFFFFF");NoStroke);
		OnCommand=cmd(y,(SCREEN_CENTER_Y*0.85)-48);
		GainFocusCommand=cmd(accelerate,0.15;zoom,1;diffuse,color("1,1,1,1"));
		LoseFocusCommand=cmd(stoptweening;decelerate,0.15;zoom,0.8;diffuse,color("0.6,0.6,0.6,0.9"));
	};

--[[
	-- repurpose as cover name?
	AutoText("frutiger")..{
		Name="Descrption"..iIndex;
		Text=THEME:GetString(Var 'LoadingScreen',sName.."Description");
		InitCommand=cmd(shadowlength,0;zoom,0.6;diffuse,color("#FFFFFF");NoStroke);
		OnCommand=cmd(y,SCREEN_CENTER_Y*0.8);
	};
]]
};

return t;